require "MF_ISMoodle"

local TABAS_Moodles = {}

if MF then
    MF.createMoodle("Wet_Bathing")
    MF.createMoodle("CoolingBody")
    MF.createMoodle("WarmingBody")
    MF.createMoodle("BodyGrime")
end

local TABAS_GT = require("TABAS_GameTimes")

function TABAS_Moodles.moodleUpdate(character)
    local modData = character:getModData()
    if character:isAsleep() and modData.bathBenefitedLimit then
        modData.bathBenefitedLimit = nil
    end
    if not MF then return end

    local isBathing = modData.isBathing
    local bathingWet = MF.getMoodle("Wet_Bathing", character:getPlayerNum())
    local cooling = MF.getMoodle("CoolingBody", character:getPlayerNum())
    local warming = MF.getMoodle("WarmingBody", character:getPlayerNum())
    local moodleGrime = MF.getMoodle("BodyGrime", character:getPlayerNum())
    local enableGrime = SandboxVars.TakeABathAndShower.EnableBodyGrime and SandboxVars.TakeABathAndShower.EnableBodyGrimeMoodle
    -- Bathing Wet
    if bathingWet ~= nil then
        -- afterBathing delays the start time of the bathinWetTimer.
        local afterBathing = modData.afterBathing
        local bwTime = modData.bathingWetTimer or 0
        if bwTime > 0  then
            character:getBodyDamage():setWetness(0)
            if bwTime > 500 then
                bathingWet:setValue(1)
            else
                bathingWet:setValue(0.6)
            end
            if not isBathing then
                if afterBathing and afterBathing > 0 then
                    modData.afterBathing = afterBathing - 0.002 * TABAS_GT.GameTime:getMultiplier()
                else
                    bwTime = bwTime - 0.48 * TABAS_GT.GameTime:getMultiplier()
                    if bwTime < 0.0 then bwTime = 0.0 end
                    modData.bathingWetTimer = bwTime
                end
            end
        elseif bathingWet:getValue() > 0.5 then
            -- When bathinWetTimer becomes 0 or less, it will become normal Wet,
            -- so it is necessary to perform TABAS_Dryself before that.
            bathingWet:setValue(0.5)
            character:getBodyDamage():setWetness(50)
        elseif afterBathing ~= nil then
            modData.bathingWetTimer = nil
            modData.isBathing = nil
            modData.afterBathing = nil
        end
    end
    -- Bathing CoolingBody
    if cooling ~= nil and cooling:getValue() > 0.5 then
        if isBathing then
            local bodyDamage = character:getBodyDamage()
            bodyDamage:setUnhappynessLevel(bodyDamage:getUnhappynessLevel() - 0.003 * TABAS_GT.GameTime:getMultiplier())
        else
            cooling:setValue(0.5)
        end
    end
    -- Bathing WarmingBody
    if warming ~= nil and warming:getValue() > 0.5 then
        if isBathing then
            local bodyDamage = character:getBodyDamage()
            bodyDamage:setUnhappynessLevel(bodyDamage:getUnhappynessLevel() - 0.003 * TABAS_GT.GameTime:getMultiplier())
        else
            warming:setValue(0.5)
        end
    end

    -- Body Grime
    local bodyGrime = modData.BodyGrime
    if enableGrime then
        if moodleGrime ~= nil and bodyGrime then
            if bodyGrime > 80 then
                moodleGrime:setValue(0)
            elseif bodyGrime > 60 then
                moodleGrime:setValue(0.2)
            elseif bodyGrime > 40 then
                moodleGrime:setValue(0.3)
            elseif bodyGrime > 20 then
                moodleGrime:setValue(0.4)
            elseif moodleGrime:getValue() ~= 0.5 then
                moodleGrime:setValue(0.5)
            end
        end
    else
        moodleGrime:setValue(0.5)
    end
end


local function TABASMoodlesUpdate()
    for i=0, getNumActivePlayers()-1 do
        local character = getSpecificPlayer(i)
        if character then
            TABAS_Moodles.moodleUpdate(character)
        end
    end
end

Events.OnPlayerUpdate.Add(TABASMoodlesUpdate)